/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWFieldUsageDialog;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWSchemaElementEditor;
import filenet.vw.toolkit.design.property.tables.VWXMLFieldTableModel;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWXMLDataFieldPanel
extends JPanel
implements IVWToolbarBorderActionListener,
TableModelListener,
ListSelectionListener,
IVWPropertyChangeListener,
IVWTableActionListener {
    private VWToolbarBorder m_nameBorder = null;
    private VWTable m_xmlDataFieldTable = null;
    private VWXMLFieldTableModel m_xmlFieldTableModel = null;
    private VWAuthPropertyData m_authPropertyData = null;

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.m_xmlDataFieldTable.stopEditing();
            if (event.getSource() == this.m_nameBorder) {
                int nRowIndex = this.m_xmlDataFieldTable.getSelectedRow();
                if (nRowIndex == -1) {
                    return;
                }
                switch (event.getID()) {
                    case 64: {
                        this.m_xmlFieldTableModel.copyItem(nRowIndex);
                        this.m_xmlDataFieldTable.ensureRowIsVisible(this.m_xmlDataFieldTable.getSelectedRow());
                        break;
                    }
                    case 0x10000000: {
                        this.m_xmlFieldTableModel.deleteItem(nRowIndex);
                        break;
                    }
                    case 512: {
                        this.onFieldUsage();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_xmlDataFieldTable.getRowCount() - 1) {
                    nRow = this.m_xmlDataFieldTable.getRowCount() - 1;
                }
                if (nRow == this.m_xmlDataFieldTable.getSelectedRow()) {
                    this.m_xmlDataFieldTable.clearSelection();
                }
                this.m_xmlDataFieldTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
            case 0: {
                if (event.getColumn() != -1 || this.m_xmlDataFieldTable.getSelectedRow() != event.getLastRow()) break;
                this.updateToolbarButtonStates();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            this.updateToolbarButtonStates();
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        if (this.m_xmlFieldTableModel == null) {
            return;
        }
        Object source = event.getSource();
        if (source instanceof IVWPropertyChangeSource && source != this) {
            switch (event.getID()) {
                case 547: 
                case 548: 
                case 549: {
                    this.m_xmlFieldTableModel.getSchemaComboBox();
                }
            }
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_xmlDataFieldTable == null) break;
                this.m_xmlDataFieldTable.stopEditing();
            }
        }
    }

    protected void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.createControls();
            this.reinitialize();
            this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        if (this.m_xmlFieldTableModel != null) {
            this.m_xmlFieldTableModel.reinitialize();
        }
        if (this.m_xmlDataFieldTable != null) {
            this.m_xmlDataFieldTable.clearSelection();
            this.m_xmlDataFieldTable.setRowSelectionInterval(0, 0);
        }
    }

    protected void stopEditing() {
        if (this.m_xmlDataFieldTable != null) {
            this.m_xmlDataFieldTable.stopEditing();
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getTableActionEventNotifier().removeTableActionListener(this);
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        if (this.m_nameBorder != null) {
            this.m_nameBorder.removeToolbarBorderActionNotifier(this);
            this.m_nameBorder = null;
        }
        if (this.m_xmlDataFieldTable != null) {
            this.m_xmlDataFieldTable.getSelectionModel().removeListSelectionListener(this);
            this.m_xmlDataFieldTable = null;
        }
        if (this.m_xmlFieldTableModel != null) {
            this.m_xmlFieldTableModel.removeTableModelListener(this);
            this.m_xmlFieldTableModel = null;
        }
        this.m_authPropertyData = null;
    }

    private void createControls() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_nameBorder = new VWToolbarBorder(VWResource.s_xmlDataFields, 268436032);
        this.m_nameBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_nameBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        this.m_nameBorder.addToolbarBorderActionNotifier(this);
        this.add((Component)this.m_nameBorder, "Center");
        JPanel xmlSchemaNamePanel = this.m_nameBorder.getClientPanel();
        xmlSchemaNamePanel.setLayout(new BorderLayout());
        this.m_xmlFieldTableModel = new VWXMLFieldTableModel(this.m_authPropertyData);
        this.m_xmlFieldTableModel.addTableModelListener(this);
        this.m_xmlDataFieldTable = new VWTable(this.m_xmlFieldTableModel);
        this.m_xmlDataFieldTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_xmlDataFieldTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        ListSelectionModel lsModel = this.m_xmlDataFieldTable.getSelectionModel();
        if (lsModel != null) {
            lsModel.setSelectionMode(0);
            lsModel.addListSelectionListener(this);
        }
        xmlSchemaNamePanel.add(new JScrollPane(this.m_xmlDataFieldTable));
        TableColumn tcElement = null;
        if (this.m_authPropertyData.getShowInheritedProperties() && (tcElement = this.m_xmlDataFieldTable.getColumnModel().getColumn(this.m_xmlFieldTableModel.getActualColumnIndex(0))) != null) {
            tcElement.setMaxWidth(20);
            tcElement.setMinWidth(20);
        }
        if ((tcElement = this.m_xmlDataFieldTable.getColumnModel().getColumn(this.m_xmlFieldTableModel.getActualColumnIndex(2))) != null) {
            tcElement.setCellEditor(new DefaultCellEditor(this.m_xmlFieldTableModel.getSchemaComboBox()));
            tcElement.setCellRenderer(new VWTableCellRenderer());
        }
        if ((tcElement = this.m_xmlDataFieldTable.getColumnModel().getColumn(this.m_xmlFieldTableModel.getActualColumnIndex(3))) != null) {
            tcElement.setCellEditor(new VWSchemaElementEditor(this.m_xmlFieldTableModel));
            tcElement.setCellRenderer(new VWTableCellRenderer());
        }
        if ((tcElement = this.m_xmlDataFieldTable.getColumnModel().getColumn(this.m_xmlFieldTableModel.getActualColumnIndex(5))) != null) {
            tcElement.setCellEditor(new DefaultCellEditor(this.m_xmlFieldTableModel.getMergeTypeComboBox()));
            tcElement.setCellRenderer(new VWTableCellRenderer());
        }
        if ((tcElement = this.m_xmlDataFieldTable.getColumnModel().getColumn(this.m_xmlFieldTableModel.getActualColumnIndex(6))) != null) {
            tcElement.setCellEditor(new VWFieldsCellEditor(this.m_authPropertyData.getMainContainer(), false));
            tcElement.setCellRenderer(new VWFieldsCellRenderer());
        }
        if ((tcElement = this.m_xmlDataFieldTable.getColumnModel().getColumn(this.m_xmlFieldTableModel.getActualColumnIndex(7))) != null) {
            tcElement.setCellRenderer(new VWFieldsCellRenderer());
        }
    }

    private void updateToolbarButtonStates() {
        int nRowCount;
        this.m_nameBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_nameBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        int nRowIndex = this.m_xmlDataFieldTable.getSelectedRow();
        if (this.m_xmlFieldTableModel != null && nRowIndex != -1 && nRowIndex != (nRowCount = this.m_xmlFieldTableModel.getRowCount()) - 1) {
            int nButtons = 576;
            if (this.m_xmlFieldTableModel.canDeleteRow(nRowIndex)) {
                nButtons |= 0x10000000;
            }
            this.m_nameBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_nameBorder.getClientPanel(), 1, nButtons));
        }
    }

    public void onFieldUsage() {
        try {
            int nRowIndex = this.m_xmlDataFieldTable.getSelectedRow();
            String fieldName = (String)this.m_xmlFieldTableModel.getValueAt(nRowIndex, 1);
            if (this.m_authPropertyData != null) {
                VWFieldDefinition fieldDef = this.m_authPropertyData.getField(fieldName);
                VWFieldUsageDialog fieldUsageDialog = new VWFieldUsageDialog(this.m_authPropertyData.getMainContainer());
                fieldUsageDialog.init(this.m_authPropertyData, fieldDef);
                if (fieldUsageDialog.hasMaps()) {
                    fieldUsageDialog.setVisible(true);
                } else {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_noAvailableWritableMaps, 2);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

